<?php
    $footerContent = getContent('footer.content', true);
    $socialElements = getContent('social_icon.element', false, null, true);
    $policyElements = getContent('policy_pages.element', false, null, true);
?>

<div class="row g-4 justify-content-between">
    <div class="col-sm-12 col-xxl-4">
        <h5 class="footer__title">
            <?php echo e(__(@$footerContent->data_values->heading)); ?>

        </h5>
        <p class="footer__about">
            <?php echo e(__(@$footerContent->data_values->details)); ?>

        </p>
        <ul class="list list--row social-list flex-wrap">
            <?php $__currentLoopData = $socialElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <a class="social-list__icon" href="<?php echo e(@$social->data_values->url); ?>" target="_blank">
                        <?php echo @$social->data_values->icon ?>
                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>

    <div class="col-sm-4 col-xxl-3">
        <h5 class="footer__title">
            <?php echo app('translator')->get('Usefull Link'); ?>
        </h5>
        <ul class="list footer__list">
            <li>
                <a class="footer__link" href="<?php echo e(route('home')); ?>"> <?php echo app('translator')->get('Home'); ?> </a>
            </li>
            <li>
                <a class="footer__link" href="<?php echo e(route('blog')); ?>"> <?php echo app('translator')->get('News & Updates'); ?> </a>
            </li>
            <li>
                <a class="footer__link" href="<?php echo e(route('contact')); ?>"> <?php echo app('translator')->get('Contact'); ?> </a>
            </li>
        </ul>
    </div>

    <div class="col-sm-4 col-xxl-2">
        <h5 class="footer__title">
            <?php echo app('translator')->get('Company Policy'); ?>
        </h5>
        <ul class="list footer__list">
            <?php $__currentLoopData = $policyElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <a class="footer__link" href="<?php echo e(route('policy.pages', $policy->slug)); ?>">
                        <?php echo e(__(@$policy->data_values->title)); ?>

                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
</div>
<?php /**PATH /home/ugurwpum/public_html/bet4.cashrall.com/core/resources/views/templates/basic/partials/footer_top.blade.php ENDPATH**/ ?>