<li class="betslip-item" data-outcome_id="<?php echo e(@$outcome->id); ?>" data-outcome_odds="<?php echo e($bet->odds); ?>">
    <?php
        $category = $outcome->market->game->league->category;
        $league = $outcome->market->game->league;
        $market = $outcome->market;
    ?>
    <div class="betslip-item-header">
        <div class="betslip-item-league">
            <?php
                echo $category->icon;
            ?>
            <span class="betslip-item-league__name"><?php echo e(__($league->name)); ?></span>
        </div>
        <button class="betslip-item-close removeFromSlip" data-outcome_id="<?php echo e(@$outcome->id); ?>" type="button">
            <i class="las la-times"></i>
        </button>
    </div>
    <div class="betslip-item-body">
        <div class="betslip-item-teams">
            <?php if($market->market_type != 'outrights'): ?>
                <div class="betslip-item-team">
                    <img class="betslip-item-team__logo" src="<?php echo e($market->game?->teamOne?->teamImage()); ?>" alt="team-image">
                    <span class="betslip-item-team__name"><?php echo e(__($market->game?->teamOne?->short_name)); ?></span>
                </div>
                <div class="betslip-item-team">
                    <img class="betslip-item-team__logo" src="<?php echo e($market->game?->teamTwo?->teamImage()); ?>" alt="team-image">
                    <span class="betslip-item-team__name"><?php echo e(__(@$market->game->teamTwo?->short_name)); ?></span>
                </div>
            <?php endif; ?>
        </div>
        <div class="betslip-item-market">
            <span class="betslip-item-market__type"><?php echo e(@$outcome->market->title); ?></span>

            <div class="betslip-item-market__wrapper">
                <span class="betslip-item-market__label"><?php echo e(__($outcome->name)); ?></span>
                <?php if(isSuspendBet($bet)): ?>
                    <div class="badge badge--danger"><?php echo app('translator')->get('Suspended'); ?></div>
                <?php else: ?>
                    <div class="betslip-item-market__score"><?php echo e(rateData($bet->odds)); ?></div>
                <?php endif; ?>
            </div>
        </div>
        <div class="betslip-item-stake">
            <label class="betslip-item-stake__label"><?php echo app('translator')->get('Stake'); ?></label>
            <div class="input-group">
                <span class="input-group-text"><?php echo e(gs('cur_sym')); ?></span>
                <input class="form-control form--control investAmount" name="invest_amount" type="number" <?php if(@$bet->stake_amount): ?> value="<?php echo e(@$bet->stake_amount); ?>" <?php endif; ?> autocomplete="off" step="any" placeholder="0.0">
                <span class="input-group-text"><?php echo e(gs('cur_text')); ?></span>
            </div>
            <small class="text--danger validation-msg"></small>
        </div>
        <div class="betslip-item-return">
            <p class="betslip-item-return__text"><?php echo app('translator')->get('Potential winnings'); ?> <span class="bet-return-amount"><?php echo e(showAmount($bet->return_amount, currencyFormat: false)); ?> <?php echo e(gs('cur_text')); ?></span></p>
        </div>
    </div>
</li>
<?php /**PATH /home/ugurwpum/public_html/bet4.cashrall.com/core/resources/views/templates/basic/partials/bet_slip_item.blade.php ENDPATH**/ ?>