<?php $__env->startSection('bet'); ?>
    <?php
        $outcomesId = collect(session()->get('bets'))->pluck('outcome_id')->toArray();
    ?>
    <div class="odd-list pt-0">
        <div class="odd-list__title"><?php echo app('translator')->get('Markets'); ?></div>
        <div class="row gx-0 pd-lg-15 gx-lg-3 gy-3">
            <div class="col-12">
                <div class="odd-list__head">
                    <?php if($game->teamOne && $game->teamTwo): ?>
                        <div class="odd-list__team">
                            <div class="odd-list__team-name"><?php echo e(__($game->teamOne->name)); ?></div>
                            <div class="odd-list__team-img">
                                <img class="odd-list__team-img-is" src="<?php echo e($game->teamOne->teamImage()); ?>" alt="image" />
                            </div>
                        </div>

                        <div class="odd-list__team-divide"><?php echo app('translator')->get('VS'); ?></div>

                        <div class="odd-list__team justify-content-end">
                            <div class="odd-list__team-img">
                                <img class="odd-list__team-img-is" src="<?php echo e($game->teamTwo->teamImage()); ?>" alt="image" />
                            </div>
                            <div class="odd-list__team-name"><?php echo e(__($game->teamTwo->name)); ?></div>
                        </div>
                    <?php else: ?>
                        <div class="odd-list__team-name"><?php echo e(__($game->league->name)); ?></div>
                    <?php endif; ?>
                </div>

                <div class="odd-list__body">
                    <div class="odd-list__body-content">
                        <?php $__empty_1 = true; $__currentLoopData = $game->markets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $market): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="accordion accordion--odd">
                                <div class="accordion-item ">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#market-<?php echo e($market->id); ?>" aria-expanded="true">
                                            <?php echo e(__($market->title ?? $market->market_title)); ?>

                                        </button>
                                    </h2>
                                    <div id="market-<?php echo e($market->id); ?>" class="accordion-collapse collapse show">
                                        <div class="accordion-body">
                                            <ul class="odd-list__outcomes">
                                                <?php $__empty_2 = true; $__currentLoopData = $market->outcomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outcome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                    <li class="flex-between">
                                                        <span class="odd-list__outcome-text">
                                                            <?php echo e(__($outcome->name)); ?>

                                                            <?php if($outcome->point): ?>
                                                                (<?php echo e($outcome->point); ?>)
                                                            <?php endif; ?>
                                                        </span>
                                                        <button class="odd-list__outcome oddBtn <?php if(in_array($outcome->id, $outcomesId)): ?> active <?php endif; ?> <?php if($outcome->locked || $market->locked): ?> locked <?php endif; ?>" data-outcome_id="<?php echo e($outcome->id); ?>">
                                                            <span class="odd-list__outcome-ratio"><?php echo e(rateData($outcome->odds)); ?> </span>
                                                        </button>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                    <small class="text-muted"> <?php echo app('translator')->get('No odds available for now'); ?></small>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="empty-message mt-3">
                                <img class="img-fluid" src="<?php echo e(asset($activeTemplateTrue . '/images/empty_message.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                <p><?php echo app('translator')->get('No markets available for now'); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.bet', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ugurwpum/public_html/bet4.cashrall.com/core/resources/views/templates/basic/markets.blade.php ENDPATH**/ ?>