<?php $__env->startSection('panel'); ?>
    <div class="row gy-3">
        <?php $__currentLoopData = $crons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cron): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-12">
                <div class="card <?php if($cron->logs->where('error', '!=', null)->count()): ?> error-bg <?php endif; ?>">

                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0"><?php echo e(__($cron->name)); ?></h5>

                        <div class="d-flex flex-lg-row flex-column justify-content-between gap-2">
                            <div class="flex-shrink-0 text-end d-flex align-items-start gap-2">
                                <a href="<?php echo e(route('admin.cron.schedule.logs', $cron->id)); ?>" class="btn btn-sm btn-outline--primary"><i class="las la-history"></i> <?php echo app('translator')->get('Logs'); ?></a>

                                <a href="<?php echo e(route('cron.manual.run', $cron->alias)); ?>" class="btn btn-sm btn-outline--success"><i class="las la-check-circle"></i> <?php echo app('translator')->get('Run Now'); ?></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">

                        <div>
                            <small class="fw-bold text-muted"><?php echo app('translator')->get('Command'); ?>: </small>
                            <small>
                                <span class="text--info fw-bold">curl -s <?php echo e(route('home') . '/' . $cron->url); ?></span>
                            </small>
                        </div>

                        <div>
                            <small class="fw-bold text-muted"><?php echo app('translator')->get('Last Run'); ?>: </small>
                            <small class="text-muted">
                                <?php if($cron->last_run): ?>
                                    <?php if(Carbon\Carbon::parse($cron->last_run)->isToday()): ?>
                                        <?php echo app('translator')->get('Today'); ?>,
                                    <?php elseif(Carbon\Carbon::parse($cron->last_run)->isYesterday()): ?>
                                        <?php echo app('translator')->get('Yesterday'); ?>,
                                    <?php else: ?>
                                        <?php echo e(showDateTime($cron->last_run)); ?>

                                    <?php endif; ?>
                                    <?php echo e(showDateTime($cron->last_run, 'h:i A')); ?>

                                <?php else: ?>
                                    --
                                <?php endif; ?>
                            </small>
                        </div>

                        <div>
                            <small class="fw-bold text-muted"><?php echo app('translator')->get('Interval Recommendation'); ?>: <span class="fw-semibold text--warning"><?php echo e($cron->interval_info); ?></span></small>
                        </div>

                        <?php if($cron->description): ?>
                            <p class="mt-2"><i class="la la-info-circle"></i> <?php echo e(__($cron->description)); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .error-bg {
            background-color: #f2dede;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ugurwpum/public_html/bet4.cashrall.com/core/resources/views/admin/cron/index.blade.php ENDPATH**/ ?>