    <div class="header-fluid-custom-parent">

        <div class="logo">
            <a href="<?php echo e(route('home')); ?>">
                <img class="img-fluid" src="<?php echo e(siteLogo()); ?>" alt="<?php echo app('translator')->get('logo'); ?>">
            </a>
        </div>

        <nav class="primary-menu-container">

            <ul class="align-items-center justify-content-start gap-3 mb-0 p-0 list-unstyled d-none d-lg-flex">
                <li>
                    <a href="<?php echo e(route('home')); ?>" class="text-white sm-text">
                        <?php echo app('translator')->get('Home'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('blog')); ?>" class="text-white sm-text">
                        <?php echo app('translator')->get('News & Updates'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('contact')); ?>" class="text-white sm-text">
                        <?php echo app('translator')->get('Contact'); ?>
                    </a>
                </li>
            </ul>

            <ul class="list list--row primary-menu justify-content-end align-items-center right-side-nav gap-3 gap-sm-4">
                <li>
                    <div class="select-lang--container">
                        <div class="select-lang">
                            <select class="form-select oddsType">
                                <option value="" disabled><?php echo app('translator')->get('Odds Type'); ?></option>
                                <option value="decimal" <?php if(session('odds_type') == 'decimal'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Decimal Odds'); ?></option>
                                <option value="fraction" <?php if(session('odds_type') == 'fraction'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Fraction Odds'); ?></option>
                                <option value="american" <?php if(session('odds_type') == 'american'): echo 'selected'; endif; ?>><?php echo app('translator')->get('American Odds'); ?></option>
                            </select>
                        </div>
                    </div>
                </li>
                <?php if(gs('multi_language')): ?>
                    <?php
                        $languages = App\Models\Language::all();
                        $language = $languages->where('code', '!=', session('lang'));
                        $activeLanguage = $languages->where('code', session('lang'))->first();
                    ?>
                    <li>
                        <div class="dropdown-lang dropdown mt-0">
                            <a href="#" class="language-btn dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                <img class="flag" src="<?php echo e(getImage(getFilePath('language') . '/' . @$activeLanguage->image, getFileSize('language'))); ?>" alt="us">
                                <span class="language-text text-white"><?php echo e(__(@$activeLanguage->code)); ?></span>
                            </a>
                            <ul class="dropdown-menu" style="">
                                <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="javascript:void(0)" class="langSel" data-code="<?php echo e($item->code); ?>">
                                            <img class="flag" src="<?php echo e(getImage(getFilePath('language') . '/' . @$item->image, getFileSize('language'))); ?>" alt="image">
                                            <?php echo e(__(@$item->name)); ?>

                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </li>
                <?php endif; ?>

                <li class="d-none d-lg-block">
                    <?php if(auth()->check() && !request()->routeIs('user.*')): ?>
                        <div class="dropdown-center user-profile-dropdown">
                            <button class="dropdown-toggle user-profile-btn" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="la la-user-circle"></i> <?php echo e(auth()->user()->username); ?>

                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('user.deposit.index')); ?>"><?php echo app('translator')->get('Deposit Money'); ?></a></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('user.profile.setting')); ?>"><?php echo app('translator')->get('My Profile'); ?></a></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('user.logout')); ?>"><?php echo app('translator')->get('Logout'); ?></a></li>
                            </ul>
                        </div>
                    <?php else: ?>
                        <?php if(Route::is('user.login')): ?>
                            <a class="btn btn--signup" href="<?php echo e(route('user.register')); ?>"> <?php echo app('translator')->get('Sign Up'); ?> </a>
                        <?php else: ?>
                            <?php if(in_array(request()->route()->getName(), ['home', 'category.games', 'game.markets'])): ?>
                                <button class="btn btn--signup" data-bs-toggle="modal" data-bs-target="#loginModal" type="button">
                                    <i class="la la-sign-in"></i> <?php echo app('translator')->get('Login'); ?>
                                </button>
                            <?php else: ?>
                                <a class="btn btn--signup" href="<?php echo e(route('user.login')); ?>">
                                    <i class="la la-sign-in"></i> <?php echo app('translator')->get('Login'); ?>
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </li>
            </ul>
        </nav>
    </div>

    <?php
        $loginContent = getContent('login.content', true);
    ?>

    <?php if(in_array(request()->route()->getName(), ['home', 'category.games', 'game.markets'])): ?>
        <div class="modal fade login-modal" id="loginModal" data-bs-backdrop="static" data-bs-keyboard="false" role="dialog" aria-labelledby="modalTitleId" aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-body p-3 p-sm-5">
                        <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <h4 class="mt-0"><?php echo e(__(@$loginContent->data_values->heading)); ?></h4>
                        </div>
                        <?php echo $__env->make($activeTemplate . 'partials.login', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php /**PATH /home/ugurwpum/public_html/bet4.cashrall.com/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>