<!doctype html>
<html lang="<?php echo e(config('app.locale')); ?>" itemscope itemtype="http://schema.org/WebPage">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <link href="<?php echo e(asset('assets/global/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/global/css/all.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/custom-icon.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/line-awesome.min.css')); ?>">
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/slick.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/magnific-popup.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/simplebar.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/main.css')); ?>" rel="stylesheet">
    <?php echo $__env->yieldPushContent('style-lib'); ?>
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/custom.css')); ?>" rel="stylesheet">
    <?php echo $__env->yieldPushContent('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/color.php')); ?>?color=<?php echo e(gs('base_color')); ?>">
</head>

<?php echo loadExtension('google-analytics') ?>

<body>
    <div class="preloader">
        <div class="preloader__img">
            <img src="<?php echo e(siteFavicon()); ?>" alt="<?php echo app('translator')->get('image'); ?>" />
        </div>
    </div>

    <div class="back-to-top">
        <span class="back-top">
            <i class="las la-angle-double-up"></i>
        </span>
    </div>

    <div class="body-overlay" id="body-overlay"></div>
    <div class="header-overlay"></div>

    <?php echo $__env->yieldContent('content'); ?>

    <?php
        $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
    ?>

    <?php if($cookie->data_values->status == Status::ENABLE && !\Cookie::get('gdpr_cookie')): ?>
        <div class="cookies-card text-center hide">
            <div class="cookies-card__icon bg--base">
                <i class="las la-cookie-bite"></i>
            </div>
            <p class="mt-4 cookies-card__content"><?php echo e($cookie->data_values->short_desc); ?> <a href="<?php echo e(route('cookie.policy')); ?>" target="_blank"><?php echo app('translator')->get('learn more'); ?></a></p>
            <div class="cookies-card__btn mt-4">
                <a href="javascript:void(0)" class="btn btn--xl btn--base w-100 policy"><?php echo app('translator')->get('Allow'); ?></a>
            </div>
        </div>
    <?php endif; ?>

    <?php if(auth()->guard()->check()): ?>
        <div class="modal custom--modal" data-bs-backdrop="static" data-bs-keyboard="false" id="betModal" aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <form id="betForm" action="<?php echo e(route('user.bet.place')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <h4 class="text-center mt-0"><?php echo app('translator')->get('Place Your Bet'); ?></h4>

                            <input name="stake_amount" type="hidden">
                            <input name="type" type="hidden">
                            <h6 class="mb-0"><?php echo app('translator')->get('Review Before Placing'); ?></h6>
                            <ul class="list-group mb-3 list-group-flush">
                                <li class="list-group-item border-0 px-0 d-flex flex-column">
                                    <small class="text-muted"><?php echo app('translator')->get('Current Balance'); ?></small>
                                    <h6 class="m-0" id="userBalance"><?php echo e(showAmount(auth()->user()->balance)); ?> <a href="<?php echo e(route('user.deposit.index')); ?>" class="btn btn--sm btn--success"> <i class="la la-plus"></i> <?php echo app('translator')->get('Add Balance'); ?></a></h6>
                                </li>

                                <li class="list-group-item border-0 px-0 d-flex flex-column">
                                    <small class="text-muted"><?php echo app('translator')->get('Stake Amount'); ?> </small>
                                    <h4 class="m-0" id="betStakeAmount"></h4>
                                </li>
                                <li class="list-group-item border-0 px-0 d-flex flex-column">
                                    <small class="text-muted"><?php echo app('translator')->get('Return Amount'); ?></small>
                                    <h3 class="m-0" id="betReturnAmount"></h3>
                                </li>
                            </ul>
                        </form>

                        <small class="mb-3 d-block">
                            <i class="la la-info-circle"></i> <?php echo app('translator')->get('Once confirmed, your bet cannot be canceled or modified. Please review your selection carefully before proceeding.'); ?>
                        </small>

                        <h5 class="text-center"><?php echo app('translator')->get('Do you want to proceed?'); ?></h5>

                        <div class="d-flex gap-3">
                            <button type="button" class="btn btn--lg btn--dark flex-grow-1" data-bs-dismiss="modal"><?php echo app('translator')->get('Cancel'); ?></button>
                            <button type="submit" class="btn btn--lg btn--base flex-grow-1" form="betForm"><?php echo app('translator')->get('Confirm Bet'); ?></button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    <?php endif; ?>

    <script src="<?php echo e(asset('assets/global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/bootstrap.bundle.min.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('script-lib'); ?>

    <?php echo loadExtension('tawk-chat') ?>

    <?php echo $__env->make('partials.notify', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php if(gs('pn')): ?>
        <?php echo $__env->make('partials.push_script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>

    <script src="<?php echo e(asset($activeTemplateTrue . 'js/slick.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/jquery.magnific-popup.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/jquery.stepcycle.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/app.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('script'); ?>

    <script>
        (function($) {
            "use strict";

            $(".langSel").on("click", function() {
                window.location.href = "<?php echo e(route('home')); ?>/change/" + $(this).data('code');
            });

            $(".oddsType").on("change", function() {
                window.location.href = `<?php echo e(route('odds.type', '')); ?>/${$(this).val()}`;
            });

            $('.policy').on('click', function() {
                $.get('<?php echo e(route('cookie.accept')); ?>', function(response) {
                    $('.cookies-card').addClass('d-none');
                });
            });

            setTimeout(function() {
                $('.cookies-card').removeClass('hide')
            }, 2000);

            var inputElements = $('[type=text],select,textarea');

            $.each(inputElements, function(index, element) {
                element = $(element);
                element.closest('.form-group').find('label').attr('for', element.attr('name'));
                element.attr('id', element.attr('name'))
            });

            $.each($('input:not([type=checkbox]):not([type=hidden]), select, textarea'), function(i, element) {
                var elementType = $(element);
                if (elementType.attr('type') != 'checkbox') {
                    if (element.hasAttribute('required')) {
                        $(element).closest('.form-group').find('label').addClass('required');
                    }
                }
            });

            let disableSubmission = false;

            $('.disableSubmission').on('submit', function(e) {
                if (disableSubmission) {
                    e.preventDefault()
                } else {
                    disableSubmission = true;
                }
            });

            $.each($(".select2"), function() {
                $(this).wrap(`<div class="position-relative"></div>`).select2({
                    dropdownParent: $(this).parent(),
                });
            });

            Array.from(document.querySelectorAll('table')).forEach(table => {
                let heading = table.querySelectorAll('thead tr th');
                Array.from(table.querySelectorAll('tbody tr')).forEach(row => {
                    Array.from(row.querySelectorAll('td')).forEach((column, i) => {
                        (column.colSpan == 100) || column.setAttribute('data-label', heading[i].innerText)
                    });
                });
            });

        })(jQuery);

        function showAmount(amount, decimal = 2, separate = true, exceptZeros = false, currencyFormat = true) {
            amount *= 1;

            const settings = {
                currencyFormat: <?php echo json_encode(gs('currency_format'), 15, 512) ?>,
                currencySymbol: <?php echo json_encode(gs('cur_sym'), 15, 512) ?>,
                currencyText: <?php echo json_encode(gs('cur_text'), 15, 512) ?>,
            }

            let separator = separate ? ',' : '';
            let printAmount = amount.toFixed(decimal).replace(/\B(?=(\d{3})+(?!\d))/g, separator);

            if (exceptZeros) {
                let parts = printAmount.split('.');
                if (parseInt(parts[1]) === 0) {
                    printAmount = parts[0];
                } else {
                    printAmount = printAmount.replace(/0+$/, '');
                }
            }

            if (currencyFormat) {
                if (settings.currencyFormat === <?php echo json_encode(Status::CUR_BOTH, 15, 512) ?>) {
                    return settings.currencySymbol + printAmount + ' ' + settings.currencyText;
                } else if (settings.currencyFormat ===  <?php echo json_encode(Status::CUR_TEXT, 15, 512) ?>) {
                    return printAmount + ' ' + settings.currencyText;
                } else {
                    return settings.currencySymbol + printAmount;
                }
            }

            return printAmount;
        }
    </script>
</body>

</html>
<?php /**PATH /home/ugurwpum/public_html/bet4.cashrall.com/core/resources/views/templates/basic/layouts/app.blade.php ENDPATH**/ ?>